/*==============================================================================
This .do file converts the digitized population data from 1971-1997 
editions of the Eurostat Regional Yearbook.

Note: If population series is dated 1/1/YYYY, the population is assigned to 
year YYYY-1. 

==============================================================================*/

clear all
set more off

cd "$insheet_files/Eurostat Regional Yearbook"

*Note: Date refers to the edition of the Eurostat Regional Yearbook
 #delimit ;
local years "1971 1971 1973 1975 1977 1981 1983 1984 1985 1986 1987 1988 
		1989 1993 1994 1995 1996 1997" ; 
#delim cr


*-------------------------------------------------------------------------------
* 1. Import excel data 
*-------------------------------------------------------------------------------

foreach year in `years' {
	quietly import excel "EYB_POP.xlsx", ///
		sheet(`year') first clear 
	quietly keep nuts year total
	quietly drop if nuts==""
	
	tempfile eyb_`year'
	quietly save `eyb_`year'.dta'
}

*-------------------------------------------------------------------------------
* 2. Append dta-files
*-------------------------------------------------------------------------------
clear
foreach year in `years' {
append using `eyb_`year'.dta'
}

ren 	total 	POP_eyb 

*-------------------------------------------------------------------------------
* 3. Take median if more than one observation per year
*-------------------------------------------------------------------------------
collapse (median) POP, by(nuts year)

drop if (nuts=="BE24"|nuts=="BE31") & year==1992 
//otherwise we will have duplicates, see next do_file 

save "$dta_files/EYB_pop_1968_1996.dta", replace
